import delimited "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\price_ts.csv", clear

gen newdate = date(date, "MDY")
gen quarter = quarter(newdate)
gen month = month(newdate)
gen year = year(newdate)
gen day = day(newdate)

tostring year, gen(year_string)
tostring quarter, gen(quarter_string)
gen year_quarter_string = year_string + quarter_string

gen cusip_short = substr(cusip, 1, 8)
drop cusip
rename cusip_short cusip 

gen mve = prc*shrout
gen mve_units = mve*1000
drop mve
rename mve_units mve

by cusip, sort: gen output_indicator = _n 
br cusip if output_indicator == 1 

save "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\price_ts.dta", replace


import delimited "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\assets_ts.csv", clear


gen newdate = date(datadate, "MDY")
gen quarter = quarter(newdate)
gen month = month(newdate)
gen year = year(newdate)
gen day = day(newdate)

gen cusip_short = substr(cusip, 1, 8)
drop cusip
rename cusip_short cusip 

tostring year, gen(year_string)
tostring quarter, gen(quarter_string)
gen year_quarter_string = year_string + quarter_string

by cusip, sort: gen output_indicator = _n 
br cusip if output_indicator == 1 

gen atq_units = atq*1000000
drop atq 
rename atq_units atq


by cusip year_quarter_string, sort: gen test = _n 
br if test != 1
drop if test != 1 

save "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\assets_ts.dta", replace

merge 1:m cusip year_quarter_string using "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\price_ts.dta"

br if _merge != 3

save "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\assets_mve_merge_ts.dta", replace

drop if _merge != 3 

use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\assets_mve_merge_ts.dta", replace
gen mve_assets_ratio = mve/atq

cd "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data November 2016\"

gen name = "" 

replace name = "baml" if permno == 59408
replace name ="citi" if permno == 70519
replace name = "gs" if permno == 86868
replace name = "jpm" if permno == 47896
replace name = "ms" if permno == 69032
replace name = "wf" if permno == 38703


drop if year >2015 


gen date_use = date(date, "MDY")
br date_use 

egen id = group(name)
tsset id date_use 

drop if mve_assets_ratio <= 0 

tssmooth ma ratio_ma = mve_assets_ratio, window(90)

drop if ratio_ma <= 0 

label var ratio_ma "MVE/Total Assets"

format date_use %tdCCYY

graph twoway line ratio_ma date_use if (name == "baml" & year> 1999), xtitle("") title("MVE/A for Bank of America Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export baml_ratio.png, replace 

graph twoway line ratio_ma date_use if (name == "citi" & year> 1999), xtitle("") title("MVE/A for Citigroup Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export citi_ratio.png, replace 

graph twoway line ratio_ma date_use if (name == "ms" & year> 1999), xtitle("") title("MVE/A for Morgan Stanley Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export ms_ratio.png, replace 

graph twoway line ratio_ma date_use  if (name == "gs" & year> 1999), xtitle("") title("MVE/A for Goldman Sachs Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export gs_ratio.png, replace 

graph twoway line ratio_ma date_use   if (name == "wf" & year> 1999), xtitle("") title("MVE/A for Wells Fargo Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export wf_ratio.png, replace 

graph twoway line ratio_ma date_use if (name == "jpm" & year> 1999), xtitle("") title("MVE/A for JP Morgan Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export jpm_ratio.png, replace 


